/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.elfield;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import physicon.ap.elfield.ApparatCanvas;
import physicon.ap.elfield.Data;
import physicon.ap.elfield.OutputCanvas;
import physicon.objava3.EventSubscriber;
import physicon.objava3.HostContainer;
import physicon.objava3.HostPanel;
import physicon.objava3.SimCheckbox;
import physicon.objava3.SimCheckboxGroup;
import physicon.objava3.SimConfig;
import physicon.objava3.SimWindow;
import physicon.objava3.TextDecoration;
import physicon.objava3.physics.FloatingBand;

class Host
extends HostPanel
implements EventSubscriber {
    private OutputCanvas output;
    private OutputCanvas output2;
    private ApparatCanvas apparat;
    private double q1 = Data.spinInit[0];
    private double q2 = Data.spinInit[1];
    private boolean isModeEq2 = true;
    private FloatingBand[] fl = new FloatingBand[3];
    private SimWindow panel;
    private SimCheckboxGroup bGroup;
    private SimCheckbox[] chb = new SimCheckbox[2];
    private SimCheckbox chbox1;
    private SimCheckbox chbox2;
    private TextDecoration rbLabel;

    Host(HostContainer hc, Dimension size) {
        super(hc, size);
        this.apparat = new ApparatCanvas(this, new Point(5, 5), new Dimension(394, 214));
        this.output2 = new OutputCanvas(this, new Point(150, 261), new Dimension(114, 32), false);
        this.output = new OutputCanvas(this, new Point(150, 224), new Dimension(114, 32), true);
        this.panel = new SimWindow(this, new Point(5, 261), new Dimension(145, 72));
        this.panel.setBkgColor(SimConfig.hostBkgColor);
        Dimension slid = new Dimension(140, 32);
        String[] prefix = new String[]{Data.res.getString("q1="), Data.res.getString("q2="), Data.res.getString("d=")};
        String[] postfix = new String[]{Data.res.getString("muC"), Data.res.getString("muC"), Data.res.getString("m")};
        SimWindow parent = this;
        int y = 224;
        String[] namesFB = new String[]{"charge1Slider", "charge2Slider", "distanceSlider"};
        int i = 0;
        while (i < 3) {
            if (i == 1) {
                parent = this.panel;
                y -= this.panel.getRefPoint().y;
            }
            this.fl[i] = new FloatingBand(parent, new Point(i == 0 ? 5 : 0, y), slid, Data.spinInit[i], Data.spinMin[i], Data.spinMax[i], Data.spinStep[i], Data.controlsEvt[2 * i], Data.controlsEvt[1 + 2 * i], 70);
            this.fl[i].setName(namesFB[i]);
            this.fl[i].getTextBlock().setPrefix(prefix[i]);
            this.fl[i].getTextBlock().setPostfix(postfix[i]);
            y += 37;
            ++i;
        }
        Dimension cbSize = new Dimension(130, 15);
        this.chbox1 = new SimCheckbox(this, new Point(269, 224), cbSize, true, "", Data.controlsEvt[6], null);
        this.chbox1.setLabel(Data.res.getString("Force lines"));
        this.chbox1.setName("electricField");
        this.chbox1 = new SimCheckbox(this, new Point(269, 244), cbSize, true, "", Data.controlsEvt[7], null);
        this.chbox1.setLabel(Data.res.getString("Potential field"));
        this.chbox1.setName("potentialField");
        this.bGroup = new SimCheckboxGroup("evtCheckboxGroup");
        this.rbLabel = new TextDecoration(this, new Point(282, 275), Data.res.getString("Config"), 32, SimConfig.CONTROL_FONT, Color.black);
        String[] namesCB = new String[]{"oneCharge", "twoCharge"};
        String[] param1 = new String[]{Data.res.getString("1chrg"), Data.res.getString("2chrg")};
        int i2 = 0;
        while (i2 < 2) {
            this.chb[i2] = new SimCheckbox(this, new Point(274, 286 + i2 * 20), new Dimension(115, 15), true, param1[i2], null, this.bGroup);
            this.chb[i2].setName(namesCB[i2]);
            ++i2;
        }
        this.subscribe("evtCheckboxGroup", this);
    }

    void changeMode(int mode) {
        if (mode == 1) {
            if (this.isModeEq2) {
                this.q2 = this.fl[1].getValue();
                this.isModeEq2 = false;
            }
            this.fl[1].setValue(0.0);
            this.publishEvent(Data.controlsEvt[3], new Double(this.fl[1].getValue()));
        } else if (!this.isModeEq2) {
            this.fl[1].setValue(this.q2);
            this.isModeEq2 = true;
            this.publishEvent(Data.controlsEvt[3], new Double(this.fl[1].getValue()));
        }
        this.panel.setVisible(mode == 2);
        this.apparat.setMode(mode);
    }

    static final int correctMode(int m) {
        return m > 2 ? 2 : (m < 1 ? 1 : m);
    }

    public void receiveEvent(Object evt) {
        SimCheckbox ch = (SimCheckbox)evt;
        int i = 0;
        while (i < 2) {
            if (ch == this.chb[i]) {
                this.changeMode(i + 1);
            }
            ++i;
        }
    }

    void updateOutput(double E, double phy) {
        this.output.setValues(E, phy);
        this.output.paintAll();
        this.output.flushBuffer();
        this.output2.setValues(E, phy);
        this.output2.paintAll();
        this.output2.flushBuffer();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        g.drawRect(269, 275, 126, 11 + this.chb.length * 20 + 1);
        g.setColor(this.getBkgColor());
        g.drawLine(277, 275, 277 + this.rbLabel.getWidth() + 10, 275);
    }
}

