/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.elfield;

import java.awt.Graphics;
import java.awt.Point;
import physicon.objava3.DecUtil;

public class DoubleVector
implements Cloneable {
    public double x;
    public double y;
    public double vx;
    public double vy;

    public DoubleVector() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DoubleVector(double vx, double vy) {
        this(vx, vy, 0.0, 0.0);
    }

    public DoubleVector(double vx, double vy, double x, double y) {
        this.setVector(vx, vy);
        this.setPoint(x, y);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exp) {
            return this;
        }
    }

    public void drawPointer(Graphics g) {
        DecUtil.drawPointer(g, new Point((int)Math.round(this.x - 100.0 * this.vx), (int)Math.round(this.y - 100.0 * this.vy)), new Point((int)Math.round(this.x), (int)Math.round(this.y)), 8);
    }

    public void drawPointerSym(Graphics g, int symY) {
        DecUtil.drawPointer(g, new Point((int)Math.round(this.x - 100.0 * this.vx), 2 * symY - (int)Math.round(this.y - 100.0 * this.vy)), new Point((int)Math.round(this.x), 2 * symY - (int)Math.round(this.y)), 8);
    }

    public double getLength() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public DoubleVector move() {
        return this.setPoint(this.x + this.vx, this.y + this.vy);
    }

    public DoubleVector norm() {
        double length = this.getLength();
        return this.resize(5.0 / length);
    }

    public void paint(Graphics g) {
        g.drawLine((int)this.x, (int)this.y, (int)(this.x + this.vx), (int)(this.y + this.vy));
    }

    public void paintSym(Graphics g, int symY) {
        g.drawLine((int)this.x, 2 * symY - (int)this.y, (int)(this.x + this.vx), 2 * symY - (int)(this.y + this.vy));
    }

    public DoubleVector perpNorm() {
        double length = this.getLength();
        return this.setVector(-this.vy, this.vx).resize(1.0 / length);
    }

    public DoubleVector resize(double k) {
        return this.setVector(this.vx * k, this.vy * k);
    }

    public DoubleVector setAngle(double angle) {
        return this.setAngle(angle, this.getLength());
    }

    public DoubleVector setAngle(double angle, double length) {
        return this.setVector(length * Math.cos(angle), length * Math.sin(angle));
    }

    public DoubleVector setPoint(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public DoubleVector setVector(double vx, double vy) {
        this.vx = vx;
        this.vy = vy;
        return this;
    }

    public static DoubleVector sum(DoubleVector v1, DoubleVector v2) {
        return new DoubleVector().setVector(v1.vx + v2.vx, v1.vy + v2.vy).setPoint(v1.x, v1.y);
    }

    public String toString() {
        return "DoubleVector: [" + this.x + ", " + this.y + "]-[" + this.vx + ", " + this.vy + "]";
    }

    public DoubleVector turn() {
        return this.setVector(-this.vx, -this.vy);
    }
}

