/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.capacity;

import java.awt.Dimension;
import java.awt.Point;
import physicon.ap.capacity.Apparatus;
import physicon.ap.capacity.Data;
import physicon.ap.capacity.OutputBox;
import physicon.objava3.EventSubscriber;
import physicon.objava3.HostContainer;
import physicon.objava3.HostPanel;
import physicon.objava3.SimCheckbox;
import physicon.objava3.SimTimer;
import physicon.objava3.physics.FloatingBand;

public class Host
extends HostPanel
implements EventSubscriber {
    private Apparatus m_apparatus;
    private OutputBox m_outputBox;
    private FloatingBand sbS;
    private FloatingBand sbQ;
    private SimCheckbox cbEl;
    private SimCheckbox cbFl;
    private SimCheckbox cbF;
    private SimTimer m_timer = null;
    EventSubscriber onSSet = new EventSubscriber(){

        public void receiveEvent(Object evt) {
            double _s = 1.0E-8 * (Double)evt;
            Host.this.publishEvent("evtReset", null);
            ((Host)Host.this).m_apparatus.preSet = false;
            Host.this.m_apparatus.setS(_s);
            Host.this.m_outputBox.setF(Host.this.m_apparatus.getF());
            Host.this.publishEvent("evtRun", null);
        }
    };
    EventSubscriber onS = new EventSubscriber(){

        public void receiveEvent(Object evt) {
            Host.this.publishEvent("evtReset", null);
            ((Host)Host.this).m_apparatus.preSet = true;
            Host.this.m_apparatus.setS(0.0);
        }
    };
    EventSubscriber onQ = new EventSubscriber(){

        public void receiveEvent(Object evt) {
            double _q = 1.0E-8 * (Double)evt;
            ((Host)Host.this).m_apparatus.preSet = false;
            Host.this.m_apparatus.setQ(_q);
            Host.this.m_outputBox.setF(Host.this.m_apparatus.getF());
        }
    };
    EventSubscriber onQDragged = new EventSubscriber(){

        public void receiveEvent(Object evt) {
            Host.this.m_apparatus.setProbePos((Point)evt);
            Host.this.m_outputBox.setF(Host.this.m_apparatus.getF());
        }
    };
    EventSubscriber onEl = new EventSubscriber(){

        public void receiveEvent(Object obj) {
            Host.this.publishEvent("evtReset", null);
            ((Host)Host.this).m_apparatus.redraw = true;
            ((Host)Host.this).m_apparatus.showEl = Host.this.cbEl.getState();
            Host.this.publishEvent("evtRun", null);
        }
    };
    EventSubscriber onFl = new EventSubscriber(){

        public void receiveEvent(Object obj) {
            Host.this.publishEvent("evtReset", null);
            ((Host)Host.this).m_apparatus.redraw = true;
            ((Host)Host.this).m_apparatus.showFl = Host.this.cbFl.getState();
            Host.this.publishEvent("evtRun", null);
        }
    };
    EventSubscriber onF = new EventSubscriber(){

        public void receiveEvent(Object obj) {
            Host.this.m_outputBox.setVisible(!Host.this.m_outputBox.isVisible());
        }
    };

    public Host(HostContainer hc, Dimension size) {
        super(hc, size);
        this.m_apparatus = new Apparatus(this, new Point(5, 5), new Dimension(400, 160));
        this.m_outputBox = new OutputBox(this, new Point(280, 215), new Dimension(125, 30));
        int d = 6;
        this.sbS = new FloatingBand(this, new Point(5, 170), new Dimension(210, 32 + d), 0.4, 0.0, 1.0, 0.1, "capacitor constant Changed", "set changed capacitor constant", 120);
        this.sbS.getTextBlock().setPrefix(Data.begin + Data.res.getString("s =") + Data.end);
        this.sbS.getTextBlock().setPostfix(Data.begin + Data.res.getString("sPost") + Data.end);
        this.sbS.setName("sigmaSlider");
        this.sbQ = new FloatingBand(this, new Point(5, 207 + d), new Dimension(210, 32), 0.5, -1.0, 1.0, 0.1, "probe charge Changed", null, 120);
        this.sbQ.getTextBlock().setPrefix(Data.begin + Data.res.getString("q =") + Data.end);
        this.sbQ.getTextBlock().setPostfix(Data.begin + Data.res.getString("qPost") + Data.end);
        this.sbQ.setName("chargeSlider");
        this.cbFl = new SimCheckbox(this, new Point(220, 170), new Dimension(135, 20), this.m_apparatus.showFl, Data.res.getString("cbFlLabel"), "force lines", null);
        this.cbFl.setName("onForceLines");
        this.cbEl = new SimCheckbox(this, new Point(220, 190), new Dimension(135, 20), this.m_apparatus.showEl, Data.res.getString("cbElLabel"), "equipotential lines", null);
        this.cbEl.setName("onEquiLines");
        this.cbF = new SimCheckbox(this, new Point(220, 210), new Dimension(55, 20), true, Data.res.getString("cbFLabel"), "force", null);
        this.cbF.setName("onForce");
        this.subscribe("capacitor constant Changed", this.onS);
        this.subscribe("set changed capacitor constant", this.onSSet);
        this.subscribe("probe charge Changed", this.onQ);
        this.subscribe("equipotential lines", this.onEl);
        this.subscribe("force lines", this.onFl);
        this.subscribe("force", this.onF);
        this.subscribe("probe Dragged", this.onQDragged);
        this.subscribe("evtTimer", this);
    }

    public void destroy() {
        if (this.m_timer != null) {
            this.m_timer.exitTimer();
        }
        this.m_timer = null;
        super.destroy();
    }

    public void onCreate() {
        super.onCreate();
        this.m_timer = new SimTimer(this.getEventPublisher(), 50);
        this.m_timer.start();
        this.m_outputBox.setF(this.m_apparatus.getF());
        this.m_outputBox.repaint();
        this.m_apparatus.setQ(1.0E-8 * this.sbQ.getValue());
        this.m_apparatus.repaint();
        this.publishEvent("probe charge Changed", new Double(this.sbQ.getValue()));
        this.publishEvent("set changed capacitor constant", new Double(this.sbS.getValue()));
        this.publishEvent("probe Dragged", Data.probe);
        this.publishEvent("evtReset", null);
        this.m_apparatus.redraw = true;
        this.m_apparatus.showEl = this.cbEl.getState();
        this.publishEvent("evtRun", null);
    }

    public void onModeChange(int newmode) {
        switch (newmode) {
            case 1: {
                this.m_apparatus.resetToRun();
                this.setControlsEnabled(false);
                break;
            }
            case 3: {
                this.m_apparatus.reset();
                this.setControlsEnabled(true);
            }
        }
    }

    public void receiveEvent(Object o) {
        if (this.m_switch.getMode() != 1) {
            return;
        }
        try {
            if (this.m_apparatus.isCreated()) {
                this.m_apparatus.repaint();
            }
            if (this.m_outputBox.isCreated()) {
                this.m_outputBox.repaint();
            }
        }
        catch (NullPointerException e) {}
    }

    public void repaint() {
        this.paintAll();
        this.flushBuffer();
    }

    private void setControlsEnabled(boolean state) {
        this.sbS.setEnabled(state);
        this.sbQ.setEnabled(state);
        this.cbEl.setEnabled(state);
        this.cbFl.setEnabled(state);
    }
}

