/*
 * Decompiled with CFR 0.152.
 */
package physicon.ap.capacity;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import physicon.ap.capacity.CastShadow;
import physicon.ap.capacity.Data;
import physicon.ap.capacity.Weight;
import physicon.graphLib2.DoublePoint;
import physicon.objava3.DecUtil;
import physicon.objava3.SimMetaTeXBlock;
import physicon.objava3.SimObject;
import physicon.objava3.SimWindow;
import physicon.objava3.more.RectBkgSaver;
import physicon.objava3.more.RectPointAndClick;
import physicon.objava3.more.ReliefDecoration;
import physicon.objava3.more.ThickArrow;

class Apparatus
extends SimWindow {
    private double norm = 0.0;
    private double[] chargePos;
    private double[] chargeWeight;
    public boolean showEl = true;
    public boolean showFl = true;
    public boolean redraw = true;
    public boolean preSet = false;
    private RectPointAndClick qSpot;
    private ThickArrow arrowF;
    private RectBkgSaver bkg;
    private Dimension bkgSize;
    private Color bkgColor;
    private Point probe = Data.probe;
    private DoublePoint force = new DoublePoint(0.0, 0.0);
    private Rectangle upperPl;
    private Rectangle lowerPl;
    private double s = 4.0E-9;
    private double q = 5.0E-9;
    private SimMetaTeXBlock fLabel;
    private CastShadow qLabel;

    public Apparatus(SimWindow _parent, Point _refpoint, Dimension _size) {
        super(_parent, _refpoint, _size);
        new ReliefDecoration(this);
        this.bkgSize = _size;
        this.bkgColor = this.getBkgColor();
        this.bkg = new RectBkgSaver(this, new Point(0, 0), new Rectangle(this.bkgSize)){

            public void paint(Graphics g) {
            }
        };
        this.qSpot = new RectPointAndClick((SimObject)this, new Rectangle(new Point(0, 0), new Dimension(this.bkgSize.width, this.bkgSize.height)), "probe Dragged");
        this.qSpot.setVisible(false);
        this.arrowF = new ThickArrow(this, new Point(0, 0), new Point(0, 0), Color.magenta, Color.magenta, 3, 2, 60);
        this.arrowF.setVisible(true);
        this.qLabel = new CastShadow((SimObject)this, new Point(0, 0), "q", "qShadow", 9);
        this.fLabel = new SimMetaTeXBlock(this, new Point(0, 0), Data.begin + Data.res.getString("f") + Data.end, 1, 2);
        this.fLabel.setVisible(true);
        new SimMetaTeXBlock(this, new Point(200, 31), Data.begin + Data.res.getString("posQ") + Data.end, 20);
        new SimMetaTeXBlock(this, new Point(200, 129), Data.begin + Data.res.getString("negQ") + Data.end, 12);
        this.chargePos = new double[250];
        this.chargeWeight = new double[250];
    }

    public void setS(double _s) {
        this.s = _s;
        this.force = this.getRes(new DoublePoint((double)(this.probe.x - 200) / 1.0, (double)(80 - this.probe.y) / 1.0));
        this.redraw = true;
    }

    public void setQ(double _q) {
        this.q = _q;
        this.force = this.getRes(new DoublePoint((double)(this.probe.x - 200) / 1.0, (double)(80 - this.probe.y) / 1.0));
        this.repaint();
    }

    public void setProbePos(Point pt) {
        if (this.upperPl.contains(pt)) {
            pt = new Point(pt.x, 80 - pt.y - 40 > 0 ? this.upperPl.y : this.upperPl.y + this.upperPl.height);
        }
        if (this.lowerPl.contains(pt)) {
            pt = new Point(pt.x, pt.y - 80 - 40 > 0 ? this.lowerPl.y + this.lowerPl.height : this.lowerPl.y);
        }
        this.probe = pt;
        this.force = this.getRes(new DoublePoint((double)(this.probe.x - 200) / 1.0, (double)(80 - this.probe.y) / 1.0));
        this.repaint();
    }

    public double getF() {
        return Math.abs(this.force.length() * this.q);
    }

    private void drawCapacitor(Graphics g) {
        int num = (int)Math.round(this.s / 1.0E-9);
        int tmp = 280 / (num + 1);
        g.setColor(Data.capColor);
        g.fillRect(60, 36, 281, 9);
        g.setColor(Data.capPosColor);
        g.fillRect(62, 38, 278, 6);
        g.setColor(Data.capColor);
        g.fillRect(60, 116, 281, 9);
        g.setColor(Data.capNegColor);
        g.fillRect(62, 118, 278, 6);
        g.setColor(Color.black);
        g.drawRect(60, 36, 281, 9);
        g.drawRect(60, 116, 281, 9);
        if (this.s > 1.0E-15) {
            int i = 0;
            while (i < num) {
                g.setColor(Color.red);
                DecUtil.drawLine(g, 60 + (i + 1) * tmp - 3, 40, 60 + (i + 1) * tmp + 3, 40, 2);
                DecUtil.drawLine(g, 60 + (i + 1) * tmp + 1, 38, 60 + (i + 1) * tmp + 1, 44, 2);
                g.setColor(Color.blue);
                DecUtil.drawLine(g, 60 + (i + 1) * tmp - 3, 120, 60 + (i + 1) * tmp + 3, 120, 2);
                ++i;
            }
        }
    }

    private void drawProbe(Graphics g) {
        g.setColor(Math.abs(this.q) < 1.0E-15 ? Data.neutralColor : (this.q > 0.0 ? Data.posColor : Data.negColor));
        g.fillOval(this.probe.x - 5, this.probe.y - 5, 11, 11);
        g.setColor(Data.capColor);
        g.drawOval(this.probe.x - 5, this.probe.y - 5, 10, 10);
        this.qLabel.setRefPoint(this.probe.x + 10, this.probe.y);
    }

    /*
     * WARNING - void declaration
     */
    public void drawScene(Graphics g) {
        boolean temp = false;
        double tmp = 140.0 + this.getLine(2, true);
        if (this.s > 1.0E-15) {
            double angle;
            double y;
            double x;
            double x0;
            double y0;
            int line;
            if (this.showEl) {
                g.setColor(Data.elColor);
                line = 0;
                while ((y0 = this.getLine(line, false)) < 32.0) {
                    x0 = 1.0E-15;
                    do {
                        void var9_7;
                        angle = this.getAngle(new DoublePoint(x0, (double)var9_7), false);
                        x = x0 + 1.0 * Math.cos(angle);
                        y = var9_7 + 1.0 * Math.sin(angle);
                        g.drawLine(200 + (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * var9_7), 200 + (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                        g.drawLine(200 - (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * var9_7), 200 - (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                        g.drawLine(200 + (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * var9_7), 200 + (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                        g.drawLine(200 - (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * var9_7), 200 - (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                        x0 = x;
                        y0 = y;
                        this.flushBuffer(2, 2, this.bkgSize.width - 4, this.bkgSize.height - 4);
                    } while (x > 0.0 && Math.abs(1.0 * x) < 200.0 && 1.0 * y < 80.0);
                    ++line;
                }
            }
            if (this.showFl) {
                g.setColor(Data.flColor);
                line = 0;
                while ((x0 = this.getLine(line, true)) < tmp) {
                    y0 = 35.0;
                    if (x0 > 140.0) {
                        x0 = 140.0;
                        y0 = 44.0;
                    }
                    do {
                        angle = this.getAngle(new DoublePoint(x0, y0), true);
                        x = x0 + 1.0 * Math.cos(angle);
                        y = y0 + 1.0 * Math.sin(angle);
                        g.drawLine(200 + (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0), 200 + (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                        g.drawLine(200 - (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0), 200 - (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                        g.drawLine(200 + (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0), 200 + (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                        g.drawLine(200 - (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0), 200 - (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                        x0 = x;
                        y0 = y;
                        this.flushBuffer(2, 2, this.bkgSize.width - 4, this.bkgSize.height - 4);
                    } while (y > 0.0 && Math.abs(1.0 * x) < 200.0 && 1.0 * y < 80.0);
                    DecUtil.drawArrow(g, new Point(200 + (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y) - 5), new Point(200 + (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y) + 5), 9);
                    DecUtil.drawArrow(g, new Point(200 - (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y) - 5), new Point(200 - (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y) + 5), 9);
                    ++line;
                }
                x0 = 46.666666666666664;
                y0 = 44.0;
                do {
                    angle = this.getAngle(new DoublePoint(x0, y0), true);
                    x = x0 + 1.0 * Math.cos(angle);
                    y = y0 + 1.0 * Math.sin(angle);
                    g.drawLine(200 + (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0), 200 + (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                    g.drawLine(200 - (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0), 200 - (int)Math.round(1.0 * x), 80 - (int)Math.round(1.0 * y));
                    g.drawLine(200 + (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0), 200 + (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                    g.drawLine(200 - (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0), 200 - (int)Math.round(1.0 * x), 80 + (int)Math.round(1.0 * y));
                    if (!temp && 1.0 * y0 - 40.0 > 15.0) {
                        DecUtil.drawArrow(g, new Point(200 + (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0)), new Point(200 + (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0) - 10), 9);
                        DecUtil.drawArrow(g, new Point(200 - (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0)), new Point(200 - (int)Math.round(1.0 * x0), 80 - (int)Math.round(1.0 * y0) - 10), 9);
                        DecUtil.drawArrow(g, new Point(200 + (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0) + 10), new Point(200 + (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0)), 9);
                        DecUtil.drawArrow(g, new Point(200 - (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0) + 10), new Point(200 - (int)Math.round(1.0 * x0), 80 + (int)Math.round(1.0 * y0)), 9);
                        temp = true;
                    }
                    x0 = x;
                    y0 = y;
                    this.flushBuffer(2, 2, this.bkgSize.width - 4, this.bkgSize.height - 4);
                } while (y > 0.0 && Math.abs(1.0 * x) < 200.0 && 1.0 * y < 80.0);
            }
        }
        this.publishEvent("evtReset", null);
    }

    private double getLine(int _line, boolean isForceLines) {
        if (isForceLines) {
            return _line != 0 ? (double)_line * 1.0E-9 * 140.0 / this.s : 1.0E-15;
        }
        return _line != 0 ? 1.5 * (double)_line * 1.0E-9 * 40.0 / this.s : 1.0E-15;
    }

    private double getAngle(DoublePoint pt, boolean isForceLines) {
        double angle;
        DoublePoint res = this.getRes(pt);
        if (res.x == 0.0) {
            angle = isForceLines ? 1.5707963267948966 : 0.0;
        } else if (res.y == 0.0) {
            angle = isForceLines ? 0.0 : 1.5707963267948966;
        } else {
            double d = angle = isForceLines ? Math.atan(res.y / res.x) : Math.atan(-res.x / res.y);
        }
        if (angle < 0.0 && res.y > 0.0) {
            angle += Math.PI;
        }
        if (isForceLines && res.x < 0.0 && res.y < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    private DoublePoint getRes(DoublePoint pt) {
        DoublePoint sum = new DoublePoint(0.0, 0.0);
        double mlt = 1.47 * this.s * 4.0E-6 * 2.0 * 140.0 / (this.norm * 1.0E-9 * 5.560618996853934E-11);
        int i = 0;
        while (i < 250) {
            double x = pt.x - this.chargePos[i];
            double y = pt.y - 40.0;
            double r = Math.sqrt(x * x + y * y);
            sum.x += this.chargeWeight[i] * x / (r * r);
            sum.y += this.chargeWeight[i] * y / (r * r);
            y = pt.y + 40.0;
            r = Math.sqrt(x * x + y * y);
            sum.x -= this.chargeWeight[i] * x / (r * r);
            sum.y -= this.chargeWeight[i] * y / (r * r);
            ++i;
        }
        sum.x *= mlt;
        sum.y *= mlt;
        return sum;
    }

    private double lagrFunc(int i) {
        double tmp = 1.1485943775100402;
        double x1 = (double)i * tmp;
        int x2 = (int)x1;
        int x3 = x2 + 1;
        if (i == 0) {
            return Weight.num[0];
        }
        if (i == 286) {
            return Weight.num[286];
        }
        if (x2 == 286) {
            return Weight.num[286];
        }
        double r = Weight.num[x2] * (x1 - (double)x3) / (double)(x2 - x3) + Weight.num[x3] * (x1 - (double)x2) / (double)(x3 - x2);
        return r;
    }

    private void setChargesPos() {
        double tmp = 1.1155378486055776;
        int i = 0;
        while (i < 250) {
            this.chargePos[i] = -140.0 + (double)(i + 1) * tmp;
            this.chargeWeight[i] = this.lagrFunc(i);
            this.norm += this.chargeWeight[i];
            ++i;
        }
        this.norm /= 250.0;
        this.upperPl = new Rectangle(55, 31, 291, 19);
        this.lowerPl = new Rectangle(55, 111, 291, 19);
    }

    private void drawForce(Graphics g) {
        this.arrowF.setRefPoint(this.probe.x, this.probe.y);
        this.arrowF.setVector((int)Math.round(6.0 * this.force.x * this.q), -((int)Math.round(6.0 * this.force.y * this.q)));
        this.arrowF.setVisible(this.arrowF.getLength() > 3.0);
        this.fLabel.setRefPoint(this.probe.x + (int)Math.round(6.0 * this.force.x * this.q), this.probe.y - (int)Math.round(6.0 * this.force.y * this.q));
        this.fLabel.setAlignFlags(2 | (this.q * this.force.y < 0.0 ? 8 : 16));
        this.fLabel.setVisible(this.arrowF.getLength() > 3.0);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.redraw) {
            this.drawCapacitor(g);
            if (!this.preSet) {
                this.drawScene(g);
                this.bkg.save();
            }
        } else {
            this.bkg.restore();
        }
        this.drawProbe(g);
        this.drawForce(g);
    }

    public void resetToRun() {
        this.arrowF.setVisible(false);
        this.fLabel.setVisible(false);
    }

    public void reset() {
        this.redraw = false;
        this.arrowF.setVisible(true);
        this.fLabel.setVisible(true);
    }

    public void repaint() {
        this.qSpot.setVisible(false);
        this.paintAll();
        this.flushBuffer();
        this.qSpot.setVisible(true);
    }

    public void onCreate() {
        super.onCreate();
        this.setChargesPos();
        this.setProbePos(this.probe);
    }
}

