/*
 * Decompiled with CFR 0.152.
 */
package physicon.GraphEngine;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;
import physicon.GraphEngine.GEInterface;
import physicon.GraphEngine.GEObject;
import physicon.GraphEngine.GERecord;

public class GraphicEngine
implements Runnable {
    int x;
    int y;
    int frameRate;
    int levels;
    Color bkg;
    Component component;
    static final int pbfnum = 4;
    Image[] pbuffer;
    int width;
    int height;
    Image[] levelsbuffers;
    Rectangle changedRect = null;
    Thread mythread;
    Vector objects = new Vector();
    Vector references = new Vector();

    public synchronized void RegisterGraphicObject(GEObject gEObject) {
        if (this.references.indexOf(gEObject) != -1) {
            return;
        }
        System.out.println(" Warning! GEObject" + gEObject + " registered in GraphEngine\n" + "in the old way - directly, rather than via GEInterface; this may leed\n" + "to unproper work due to multithreading conflicts\n");
        this.references.addElement(gEObject);
        this.objects.addElement(new GERecord(gEObject));
    }

    public synchronized void RegisterGraphicObject(GEInterface gEInterface) {
        if (this.references.indexOf(gEInterface) != -1) {
            return;
        }
        gEInterface.setRedrawFlag(true);
        this.references.addElement(gEInterface);
        this.objects.addElement(new GERecord(gEInterface));
    }

    public synchronized void RemoveAllGraphicObjects() {
        this.references.removeAllElements();
        this.objects.removeAllElements();
        this.changedRect = new Rectangle(0, 0, this.width, this.height);
    }

    public synchronized void Invalidate() {
        this.changedRect = new Rectangle(0, 0, this.width, this.height);
    }

    public synchronized void setFrameRate(int n) {
        if (n <= 0) {
            System.err.println("incorect frameRate value in GraphicEngine.setFrameRate");
            return;
        }
        this.frameRate = n;
    }

    public synchronized int getFrameRate() {
        return this.frameRate;
    }

    private synchronized void ttt(Graphics graphics) {
        int n = 0;
        while (n < this.objects.size()) {
            GERecord gERecord = (GERecord)this.objects.elementAt(n);
            gERecord.update();
            if (gERecord.getRedrawFlag()) {
                if (this.changedRect == null) {
                    this.changedRect = gERecord.getGlobalUpdateRect();
                } else {
                    this.changedRect.add(gERecord.getGlobalUpdateRect());
                }
            }
            ++n;
        }
        if (this.changedRect == null) {
            return;
        }
        Vector<GERecord> vector = new Vector<GERecord>();
        int n2 = 0;
        while (n2 < this.objects.size()) {
            GERecord gERecord = (GERecord)this.objects.elementAt(n2);
            if (gERecord.belongs(this.changedRect)) {
                vector.addElement(gERecord);
            }
            ++n2;
        }
        this.Sort(vector);
        graphics.clipRect(this.changedRect.x, this.changedRect.y, this.changedRect.width + 1, this.changedRect.height + 1);
        n2 = 0;
        int n3 = 0;
        int n4 = this.width;
        int n5 = this.height;
        while (n3 < 4) {
            if (n4 >= this.changedRect.width && n5 >= this.changedRect.height) {
                n2 = n3;
            }
            ++n3;
            n4 /= 2;
            n5 /= 2;
        }
        if (n2 == 4) {
            n2 = 0;
        }
        Graphics graphics2 = this.pbuffer[n2].getGraphics();
        graphics2.translate(-this.changedRect.x, -this.changedRect.y);
        graphics2.setColor(this.bkg);
        graphics2.fillRect(this.changedRect.x, this.changedRect.y, this.changedRect.width + 1, this.changedRect.height + 1);
        n4 = 0;
        while (n4 < vector.size()) {
            ((GERecord)vector.elementAt(n4)).draw(graphics2);
            ++n4;
        }
        graphics.drawImage(this.pbuffer[n2], this.changedRect.x, this.changedRect.y, this.component);
        this.changedRect = null;
    }

    public GraphicEngine(int n, int n2, Color color, Component component, int n3, int n4, int n5, int n6) {
        this.frameRate = n2;
        this.bkg = color;
        this.component = component;
        this.width = n5;
        this.height = n6;
        this.levels = n;
        this.pbuffer = new Image[4];
        int n7 = 0;
        int n8 = this.width;
        int n9 = this.height;
        while (n7 < 4) {
            this.pbuffer[n7] = component.createImage(n8 + 1, n9 + 1);
            ++n7;
            n8 /= 2;
            n9 /= 2;
        }
        this.x = n3;
        this.y = n4;
    }

    public GraphicEngine(int n, int n2, Color color, Component component, int n3, int n4) {
        this(n, n2, color, component, 0, 0, n3, n4);
    }

    public synchronized void Stop() {
        this.mythread.stop();
    }

    public synchronized void RemoveGraphicObject(GEObject gEObject) {
        int n = this.references.indexOf(gEObject);
        if (n == -1) {
            return;
        }
        GERecord gERecord = (GERecord)this.objects.elementAt(n);
        if (this.changedRect == null) {
            this.changedRect = gERecord.getGlobalUpdateRect();
        } else {
            this.changedRect.add(gERecord.getGlobalUpdateRect());
        }
        this.references.removeElement(gEObject);
        this.objects.removeElementAt(n);
    }

    public synchronized void RemoveGraphicObject(GEInterface gEInterface) {
        int n = this.references.indexOf(gEInterface);
        if (n == -1) {
            return;
        }
        GERecord gERecord = (GERecord)this.objects.elementAt(n);
        if (this.changedRect == null) {
            this.changedRect = gERecord.getGlobalUpdateRect();
        } else {
            this.changedRect.add(gERecord.getGlobalUpdateRect());
        }
        this.references.removeElement(gEInterface);
        this.objects.removeElementAt(n);
    }

    final void Sort(Vector vector) {
        Vector vector2 = vector;
        Vector vector3 = new Vector();
        while (vector2.size() > 0) {
            double d = this.levelOf(vector2, 0);
            int n = 0;
            int n2 = 0;
            while (n2 < vector2.size()) {
                double d2 = this.levelOf(vector2, n2);
                if (d2 < d) {
                    d = d2;
                    n = n2;
                }
                ++n2;
            }
            vector3.addElement(vector2.elementAt(n));
            vector2.removeElementAt(n);
        }
        int n = 0;
        while (n < vector3.size()) {
            vector.addElement(vector3.elementAt(n));
            ++n;
        }
    }

    final double levelOf(Vector vector, int n) {
        return ((GERecord)vector.elementAt((int)n)).object.getGlobalLevel();
    }

    public void run() {
        while (true) {
            Graphics graphics = this.component.getGraphics();
            long l = System.currentTimeMillis();
            graphics.translate(this.x, this.y);
            this.ttt(graphics);
            graphics.translate(-this.x, -this.y);
            long l2 = 1000 / this.frameRate;
            l = System.currentTimeMillis() - l;
            long l3 = l2 - l;
            if (l3 <= 0L) continue;
            try {
                Thread.sleep(l3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.mythread.stop();
                continue;
            }
            break;
        }
    }

    public synchronized void setRefPoint(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.Invalidate();
    }

    public synchronized void Start() {
        this.mythread = new Thread(this);
        this.mythread.start();
    }

    public synchronized void setNewDimension(int n, int n2) {
        this.pbuffer = new Image[4];
        this.width = n;
        this.height = n2;
        int n3 = 0;
        int n4 = this.width;
        int n5 = this.height;
        while (n3 < 4) {
            this.pbuffer[n3] = this.component.createImage(n4 + 1, n5 + 1);
            ++n3;
            n4 /= 2;
            n5 /= 2;
        }
        System.gc();
        this.Invalidate();
    }
}

